﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class Customer
    Implements IComparable

    ' 用于控制使用哪些字段进行比较。
    Private Shared s_CompareField As CompareField

    Private idValue As Integer
    Private nameValue As String

    Public Property Id() As Integer
        Get
            Return idValue
        End Get
        Set(ByVal Value As Integer)
            idValue = Value
        End Set
    End Property

    Public Property Name() As String
        Get
            Return nameValue
        End Get
        Set(ByVal Value As String)
            nameValue = Value
        End Set
    End Property

    Public Enum CompareField
        Name
        Id
    End Enum

    Shared Sub New()
        ' 设置默认比较字段
        s_CompareField = CompareField.Name
    End Sub

    Public Shared Sub SetCompareKey(ByVal CompareKey As CompareField)
        ' 更改比较字段
        s_CompareField = CompareKey
    End Sub

    Public Sub New()
        ' 通过委托给下一个最复杂的构造函数设置默认值
        Me.New(-1, "No Name")
    End Sub

    Public Sub New(ByVal newId As Integer, ByVal newName As String)
        Me.Id = newId
        Me.Name = newName
    End Sub

    Public Function CompareTo(ByVal obj As Object) As Integer Implements System.IComparable.CompareTo
        ' 首先检查以确保仅与另一个客户进行比较。
        If TypeOf obj Is Customer Then
            ' 创建强类型引用
            Dim c As Customer = CType(obj, Customer)

            If s_CompareField = CompareField.Name Then
                ' 根据名称进行比较
                Return Me.Name.CompareTo(c.Name)
            Else
                ' 根据 ID 进行比较
                Return Me.Id - c.Id
            End If
        Else
            Throw New ArgumentException("Customers can only be compared against other customers. The object being passed in was a " & obj.GetType.ToString())
        End If
    End Function

    Public Overrides Function ToString() As String
        ' 通常情况下 ToString 返回完全限定的类型名称。
        ' 此示例中应为 VBNET.HowTo.Arrays.Customer
        ' 我们会对其进行重写，以便在添加到列表框中时
        ' 可以返回一个简单的显示字符串。
        Return String.Format("Id={0}, Name={1}", Me.Id, Me.Name)
    End Function
End Class
